﻿define([ 'durandal/app', 'durandal/system', 'knockout', 'services/datacontext', 'breeze', 'jquery', 'services/logger', 'select2'], function (app, system, ko, dataservice, breeze, $, logger) {
    ko.bindingHandlers.select2 = {
        init: function(el, valueAccessor, allBindingsAccessor, viewModel) {
            ko.utils.domNodeDisposal.addDisposeCallback(el, function() {
                $(el).select2('destroy');
            });

            var allBindings = allBindingsAccessor(),
                select2 = ko.utils.unwrapObservable(allBindings.select2);

            $(el).select2(select2);
        },
        update: function (el, valueAccessor, allBindingsAccessor, viewModel) {
            var allBindings = allBindingsAccessor();

            if ("value" in allBindings) {
                $(el).select2("val", allBindings.value());
            } else if ("selectedOptions" in allBindings) {
                var converted = [];
                var textAccessor = function(value) { return value; };
                if ("optionsText" in allBindings) {
                    textAccessor = function(value) {
                        var valueAccessor = function (item) { return item; }
                        if ("optionsValue" in allBindings) {
                            valueAccessor = function (item) { return item[allBindings.optionsValue]; }
                        }
                        var items = $.grep(allBindings.options(), function (e) { return valueAccessor(e) == value});
                        if (items.length == 0 || items.length > 1) {
                            return "UNKNOWN";
                        }
                        return items[0][allBindings.optionsText];
                    }
                }
                $.each(allBindings.selectedOptions(), function (key, value) {
                    converted.push({id: value, text: textAccessor(value)});
                });
                $(el).select2("data", converted);
            }
        }
    };

    return {
        filter: ko.observable().extend({ throttle: 500 }),
        healths: ko.observableArray([]),
        activeHealth: ko.observable(null),
        activeDisease: ko.observable(null),
        tags: ko.observableArray([]),
        oils: ko.observableArray([]),
        refresh: function(){
            dataservice.getHealthPartials(this.healths, true);
        },

        activate: function(){
            dataservice.getHealthPartials(this.healths, true);

            this.filter.subscribe(function(value){
                this.activeHealth(null);
                this.activeDisease(null);
                dataservice.getHealthPartials(this.healths, false, value ?  breeze.Predicate('name', 'startsWith', value) : '');
            }, this);

            this.activeHealth.subscribe(function(value){
                this.activeDisease(null);
                this.tags([]);
            }, this);

            this.activeDisease.subscribe(function(value){
                if(!value) return;
                this.oils(value.directions());

//                debugger;
            }, this);
        }
    };

});