<?php
/**  
 * A type to hold the parsed information about the filter option.
 * 
 * PHP version 5.3
 * 
 * @category  ODataPHPProd
 * @package   ODataProducer_UriProcessor_QueryProcessor_ExpressionParser
 * @author    Microsoft Open Technologies, Inc. <msopentech@microsoft.com>
 * @copyright Microsoft Open Technologies, Inc.
 * @license   New BSD license, (http://www.opensource.org/licenses/bsd-license.php)
 * @version   GIT: 1.2
 * @link      https://github.com/MSOpenTech/odataphpprod
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  Redistributions of source code must retain the above copyright notice, this list
 *  of conditions and the following disclaimer.
 *  Redistributions in binary form must reproduce the above copyright notice, this
 *  list of conditions  and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A  PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)  HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
namespace ODataProducer\UriProcessor\QueryProcessor\ExpressionParser;
use ODataProducer\UriProcessor\QueryProcessor\AnonymousFunction;
/**
 * To hold the parsed information about the filter option.
 *
 * @category  ODataPHPProd
 * @package   ODataProducer_UriProcessor_QueryProcessor_ExpressionParser
 * @author    Microsoft Open Technologies, Inc. <msopentech@microsoft.com>
 * @copyright Microsoft Open Technologies, Inc.
 * @license   New BSD license, (http://www.opensource.org/licenses/bsd-license.php)
 * @version   GIT: 1.2
 * @link      https://github.com/MSOpenTech/odataphpprod
 */
class InternalFilterInfo
{
    /**
     * The structure holds information about the navigation properties 
     * used in the filter clause (if any). 
     * 
     * @var FilterInfo
     */
    private $_filterInfo;

    /**
     * The top filter function
     * 
     * @var AnonymousFunction
     */
    private $_filterFunction;

    /**
     * The translated expression based on the Expression provider, if the end developer
     * opt for IDSQP2 then he is responsible for implementing IExpressionProvider
     * in this case this member variable will hold the expression generated through
     * custom ExpressionProvider, if user opt for IDSQP then the default 
     * PHPExpressionProvider will be used, in this case this member variable will
     * hold the PHP expression generated through the PHPExpressionProvider.
     * 
     * @var string
     */
    private $_filterExpressionAsDataSourceExpression;

    /**
     * True if the filter expression is processed using custom ExpressionProvider
     * implementation, False if its by PHPExpressionPorvider. 
     * 
     * @var bool
     */
    private $_isCustomExpression;

    /**
     * Constructs a new instance of InternalFilterInfo
     * 
     * @param FilterInfo        $filterInfo               holding navigation properties in 
     *                                                    the $filter clause.
     * @param AnonymousFunction $filterFunction           The anonymous function generated
     *                                                    from $filter clause.
     * @param string            $filterExpAsDataSourceExp The $filter expression as expression
     *                                                    specific to data source 
     * @param bool              $isCustomExpression       True if the expression is generated by
     *                                                    custom implementation of IExpressionProvider
     *                                                    false if its generated by library's 
     *                                                    PHPExpressionProvider.
     */
    public function __construct(FilterInfo $filterInfo, AnonymousFunction $filterFunction, $filterExpAsDataSourceExp, $isCustomExpression) 
    {
        $this->_filterInfo = $filterInfo;
        $this->_filterFunction = $filterFunction;
        $this->_filterExpressionAsDataSourceExpression = $filterExpAsDataSourceExp;
        $this->_isCustomExpression = $isCustomExpression;
    }

    /**
     * Get reference to resource set reference properties used to in the 
     * filter clause to be passed to IDSQP implementation calls.
     * 
     * @return OrderByInfo
     */
    public function getFilterInfo()
    {
        return $this->_filterInfo;
    }

    /**
     * Get reference to the anonymous function to be used for filtering.
     * 
     * @return AnonymousFunction
     */
    public function getFilterFunction()
    {
        return $this->_filterFunction;
    }

    /**
     * Gets the data source specific expression as string.  
     * 
     * @return string
     */
    public function getExpressionAsString()
    {
        return $this->_filterExpressionAsDataSourceExpression;
    }

    /**
     * Checks the expression (_filterExpressionAsDataSourceExpression) hold by this instance 
     * is generated by Custom expression provider or PHPExpressionProvider.
     * 
     * @return bool True if the expression is generated by custom Expression 
     *              provider, False if its by PHPExpressionProvider.
     */
    public function isCustomExpression()
    {
    	return $this->_isCustomExpression;
    }
}
?>