<?php

namespace OilDatabase\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Token
 */
class Token
{
    /**
     * @var string
     */
    private $token;

    /**
     * @var string
     */
    private $allowed;

    /**
     * @var string
     */
    private $restricted;

    /**
     * @var string
     */
    private $created;

    /**
     * @var integer
     */
    private $id;

    /**
     * @var \OilDatabase\Entity\User
     */
    private $user;

    /**
     * Set token
     *
     * @param string $token
     * @return Token
     */
    public function setToken($token = '')
    {
        $this->token = $token ? $token : md5(uniqid('old').time());

        return $this;
    }

    /**
     * Get token
     *
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user
     *
     * @param \OilDatabase\Entity\User $user
     * @return \OilDatabase\Entity\Token
     */
    public function setUser(\OilDatabase\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \OilDatabase\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set allowed
     *
     * @param string $allowed
     * @return \OilDatabase\Entity\Token
     */
    public function setAllowed($allowed)
    {
        $this->allowed = $allowed;

        return $this;
    }

    /**
     * Get token
     *
     * @return string
     */
    public function getAllowed()
    {
        return $this->allowed;
    }

    /**
     * Set restricted
     *
     * @param string $restricted
     * @return Token
     */
    public function setRestricted($restricted)
    {
        $this->restricted = $restricted;

        return $this;
    }

    /**
     * Get token
     *
     * @return string
     */
    public function getRestricted()
    {
        return $this->restricted;
    }

    /**
     * Set created
     *
     * @param string $created
     * @return Token
     */
    public function setCreated($created = null)
    {
        if(!$created) $created = time();
        $this->created = $created;

        return $this;
    }

    /**
     * Get token
     *
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }
}
