<?php

namespace OilDatabase\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Tag
 */
class Tag
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var integer
     */
    private $id;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $oils;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $diseases;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->oils = new \Doctrine\Common\Collections\ArrayCollection();
        $this->diseases = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Tag
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Add oils
     *
     * @param \OilDatabase\Entity\Oil $oils
     * @return Tag
     */
    public function addOil(\OilDatabase\Entity\Oil $oils)
    {
        $this->oils[] = $oils;

        return $this;
    }

    /**
     * Remove oils
     *
     * @param \OilDatabase\Entity\Oil $oils
     */
    public function removeOil(\OilDatabase\Entity\Oil $oils = null)
    {
        $this->oils->removeElement($oils);
    }

    /**
     * Get oils
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getOils()
    {
        return $this->oils;
    }

    /**
     * Add oils
     *
     * @param \OilDatabase\Entity\Disease $oils
     * @return Tag
     */
    public function addDisease(\OilDatabase\Entity\Disease $oils = null)
    {
        $this->diseases[] = $oils;

        return $this;
    }

    /**
     * Remove oils
     *
     * @param \OilDatabase\Entity\Disease $oils
     */
    public function removeDisease(\OilDatabase\Entity\Disease $oils)
    {
        $this->diseases->removeElement($oils);
    }

    /**
     * Get oils
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDiseases()
    {
        return $this->diseases;
    }

    /**
     * @var string
     */
    private $description;


    /**
     * Set description
     *
     * @param string $description
     * @return Tag
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }
}
