<?php

namespace OilDatabase\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Health
 */
class Health
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var integer
     */
    private $id;

    /**
     *
     * @var \Doctrine\Common\Collections\Collection
     */
    private $diseases;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->diseases = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Health
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Add diseases
     *
     * @param \OilDatabase\Entity\Disease $diseases
     * @return Health
     */
    public function addDisease(\OilDatabase\Entity\Disease $diseases)
    {
        $this->diseases[] = $diseases;

        return $this;
    }

    /**
     * Remove diseases
     *
     * @param \OilDatabase\Entity\Disease $diseases
     */
    public function removeDisease(\OilDatabase\Entity\Disease $diseases)
    {
        $this->diseases->removeElement($diseases);
    }

    /**
     * Get diseases
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDiseases()
    {
        return $this->diseases;
    }
    /**
     * @var string
     */
    private $description;


    /**
     * Set description
     *
     * @param string $description
     * @return Health
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
}
