<?php

namespace OilDatabase\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Disease
 */
class Disease
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var integer
     */
    private $id;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $tags;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $directions;

    /**
     * @var \OilDatabase\Entity\Health
     */
    private $health;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tags = new \Doctrine\Common\Collections\ArrayCollection();
        $this->directions = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Disease
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Add tags
     *
     * @param TagDisease $tags
     * @internal param \OilDatabase\Entity\TagDisease $tags
     * @return Disease
     */
    public function addTag(\OilDatabase\Entity\TagDisease $tags = null)
    {
        $this->tags[] = $tags;

        return $this;
    }

    /**
     * Remove tags
     *
     * @param \OilDatabase\Entity\TagDisease $tags
     */
    public function removeTag(\OilDatabase\Entity\TagDisease $tags)
    {
        $this->tags->removeElement($tags);
    }

    /**
     * Get tags
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTags()
    {
        return $this->tags;
    }
    /**
     * @var string
     */
    private $description;


    /**
     * Set description
     *
     * @param string $description
     * @return Disease
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set category
     *
     * @param \OilDatabase\Entity\Health $health
     * @return Disease
     */
    public function setHealth(\OilDatabase\Entity\Health $health = null)
    {
        $this->health = $health;

        return $this;
    }

    /**
     * Get category
     *
     * @return \Demo\Entity\Category
     */
    public function getHealth()
    {
        return $this->health;
    }

    /**
     * Add Direction
     *
     * @param Direction $direction
     *
     * @return Disease
     */
    public function addDirection(\OilDatabase\Entity\Direction $direction = null)
    {
        $this->directions[] = $direction;

        return $this;
    }

    /**
     * Remove tags
     *
     * @param \OilDatabase\Entity\Direction $direction
     */
    public function removeDirection(\OilDatabase\Entity\Direction $direction)
    {
        $this->directions->removeElement($direction);
    }

}
