<?php

namespace OilDatabase\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Direction
 */
class Direction
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var string
     */
    private $direction;

    /**
     * @var string
     */
    private $params;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $disease;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $oil;

    /**
     * Constructor
     */
    public function __construct()
    {
    }

    /**
     * Set direction
     *
     * @param string $direction
     * @return Direction
     */
    public function setDirection($direction)
    {
        $this->direction = $direction;

        return $this;
    }

    /**
     * Get direction
     *
     * @return string
     */
    public function getDirection()
    {
        return $this->direction;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set oil
     *
     * @param \OilDatabase\Entity\Oil $oil
     *
     * @return \OilDatabase\Entity\Direction
     */
    public function setOil(\OilDatabase\Entity\Oil $oil = null)
    {
        $this->oil = $oil;

        return $this;
    }

    /**
     *
     * @return \OilDatabase\Entity\Oil
     */
    public function getOil()
    {
        return $this->oil;
    }

    /**
     * Set disease
     *
     * @param \OilDatabase\Entity\Disease $disease
     *
     * @return \OilDatabase\Entity\Direction
     */
    public function setDisease(\OilDatabase\Entity\Disease $disease = null)
    {
        $this->disease = $disease;

        return $this;
    }

    /**
     *
     * @return \OilDatabase\Entity\Disease
     */
    public function getDisease()
    {
        return $this->disease;
    }

    /**
     * Set params
     *
     * @param Array $params
     *
     * @return \OilDatabase\Entity\Direction
     */
    public function setParams($params = array())
    {
        $this->params = json_encode($params);

        return $this;
    }

    /**
     *
     * @return Array $params
     */
    public function getParams()
    {
        return json_decode($this->params);
    }
}
