<?php

// prevent direct access
if (strpos($_SERVER['PHP_SELF'], 'bootstrap.php') !== false) {
    header('HTTP/1.0 404 Not Found');
    exit();
}

define('PROXY_DIR', __DIR__ . '/config/proxies');
define('PROXY_NAMESPACE', 'OilDatabase\Proxies');

$loader = require __DIR__ . '/vendor/autoload.php';
$app = new OilApplication();
$app->enableDebug();
$app->setAutoloader($loader);

$app->setConnection(array(
    'dbname' => 'sviet_oil',
    'user' => 'oil',
    'password' => 'edu2yme6y',
    'host' => 'localhost',
    'driver' => 'pdo_mysql',
));

// configuring doctrine, serializer and validator
// using xml mappings
$app->addMapping(array(
    'namespace' => 'OilDatabase\Entity',
    'type' => 'xml',
    'extension' => '.dcm.xml', // default ".dcm.xml"
    'doctrine' => __DIR__ . '/src/OilDatabase/Config/doctrine', // doctrine directory
    'serializer' => __DIR__ . '/src/OilDatabase/Config/serializer', // [optional] serializer metadata directory
    'validation' => __DIR__ . '/src/OilDatabase/Config/validation.xml', // [optional] validation file
));


$classes = array(
    'Diseases' => 'OilDatabase\Entity\Disease',
    'Healths' => 'OilDatabase\Entity\Health',
    'Oils' => 'OilDatabase\Entity\Oil',
    'Tags' => 'OilDatabase\Entity\Tag',
    'TagsDiseases' => 'OilDatabase\Entity\TagDisease',
    'TagsOils' => 'OilDatabase\Entity\TagOil',
    'Users' => 'OilDatabase\Entity\User',
    'Tokens' => 'OilDatabase\Entity\Token',
    'Roles' => 'OilDatabase\Entity\Role',
    'UserRoles' => 'OilDatabase\Entity\UserRole',
    'Directions' => 'OilDatabase\Entity\Direction',
);

$app->addResources($classes);
$app
    ->addLookup('Oils', 'OilDatabase\Entity\Oil')
    ->addLookup('Tags', 'OilDatabase\Entity\Tag')
//    ->addLookup('Users', 'OilDatabase\Entity\User')
;

$app->setAuthenticationObject(new Authentication($app));
// allow cross origin request
//$app->enableCors();

$app->build();

return $app;